﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace WorldLab.SampleAnalysisLib
{
    /// sample
    public class Sample
    {
        private int indepCounts;/// independent counts
        private double[] indepValues;/// dependent counts
        private double depValue;/// dependent value
        private double weight;/// weight

        public int IndepCounts/// independent counts
        {
            get
            {
                return indepCounts;
            }
            set
            {
                indepCounts = value;
            }
        }
        public double[] IndepValues/// dependent counts
        {
            get
            {
                return indepValues;
            }
            set
            {
                indepValues = value;
            }
        }
        public double DepValue/// dependent value
        {
            get
            {
                return depValue;
            }
            set
            {
                depValue = value;
            }
        }
        public double Weight/// weight
        {
            get
            {
                return weight;
            }
            set
            {
                weight = value;
            }
        }


        public Sample()
        {
            indepCounts = 0;
            indepValues = null;
            depValue = double.NaN;
            weight = double.NaN;
        }

        public Sample(int indepCnts)
        {
            IndepCounts = indepCnts;
            IndepValues = new double[indepCnts];
            for (int i = 0; i < indepCounts; ++i)
            {
                indepValues[i] = double.NaN;
            }
            depValue = double.NaN;
            weight = double.NaN;
        }

        public Sample(int indepCnts, double[] indepVals, double depVal, double wei)
        {
            indepCounts = indepCnts;
            indepValues = new double[indepCounts];
            for (int i = 0; i < indepCounts; ++i)
            {
                indepValues[i] = indepVals[i];
            }
            depValue = depVal;
            weight = wei;
        }

        public Sample(Sample source)
        {
            indepCounts = source.IndepCounts;
            indepValues = new double[indepCounts];
            for (int i = 0; i < indepCounts; ++i)
            {
                indepValues[i] = source.IndepValues[i];
            }
            depValue = source.DepValue;
            weight = source.Weight;
        }

        public void Dispose()
        {
            indepCounts = 0;
            indepValues = null;
            depValue = double.NaN;
            weight = double.NaN;
        }
    }

}
